TITLE 							                  { exa083.pde }
   'Radial Conduction in a Foil'
SELECT
   errlim=3e-5     ngrid=1     spectral_colors
VARIABLES
   U
DEFINITIONS      	{ Replace first line of definitions }
   r1=0.2     r2=1     cond=5.99e7     U1=1.0    			{ Voltage } 	
   Ex=-dx(U)     Ey=-dy(U)     E=-grad(U)     Em=magnitude(E)
   Jx=cond*Ex     Jy=cond*Ey     J=cond*E     Jm=magnitude(J)
EQUATIONS
   div( J)=0
BOUNDARIES
region 'domain' start(r2,0)
   value( U)=0  arc( center=0,0) angle=360 close		{ Outer }
   start(r1,0)  value( U)=U1  arc( center=0,0) angle=360	{ Exclude }
PLOTS
   contour( U)     surface( U)     vector( E)  norm
   contour( Jx)     contour( Jy)     contour( Jm)
END


